import React from 'react';
import {sprintf} from 'sprintf-js';
import connect from '../../../jobs/context/connect';
import {StringsConsumer} from "../context/StringsProvider";
import {ProcessConsumer} from "../context/ProcessController";
import {JOB_STATUSES} from "../../../jobs/model/jobs";

export const ProgressMessage = props => {

	const {
		strings,
		process
	} = props;

	const jobs = process.processedJobs.filter(job => job.status === JOB_STATUSES.COMPLETED);

	return (
		<div className="wpml-tm-polling-progress notice notice-warning">
			<p>
				{strings.progressText}{" "}
				{
					jobs.length > 0 && <span>{sprintf(strings.progressJobsCount, jobs.length)}</span>
				}
				<span className="spinner"/>
			</p>
		</div>
	);

};

export default connect(ProgressMessage, ProcessConsumer, StringsConsumer);