import React from 'react';
import {sprintf} from 'sprintf-js';
import connect from '../../../jobs/context/connect';
import {StringsConsumer} from "../context/StringsProvider";
import {ProcessConsumer} from "../context/ProcessController";
import {JOB_STATUSES} from "../../../jobs/model/jobs";

export const Summary = props => {

	const {
		strings,
		process
	} = props;

	if (process.confirmationHidden) {
		return '';
	}

	return (
		<div className="wpml-tm-polling-summary notice notice-success is-dismissible">
			<p>
			<strong>
				{strings.statusChecked}
			</strong>{" "}
			{
				process.processedJobs.length > 0 ?
					sprintf(strings.translationsDownloaded, process.processedJobs.filter(job => job.status === JOB_STATUSES.COMPLETED).length) :
					strings.noTranslationsDownloaded
			}
			</p>
			<button onClick={process.hideConfirmation} type="button" className="notice-dismiss"><span className="screen-reader-text">{strings.dismissNotice}</span></button>
		</div>
	);

};

export default connect(Summary, ProcessConsumer, StringsConsumer );