import {JOB_STATUSES} from "../../../jobs/model/jobs";
import {isJobEqual} from "../../../jobs/model/jobs";

const getJobsWithStatus = (jobs, syncedJobs, status) => {
	const findSyncedJob = ( job ) => {
		return syncedJobs.find( ( syncedJob ) => {

			return job.id === syncedJob.id && job.type === syncedJob.type && syncedJob.status === status;
		} );
	};

	const translatedJobs = jobs.filter( job => {
		if ( job.status === status ) {
			return true;
		}

		return findSyncedJob( job ) !== undefined;
	} ).map( job => {
		const syncedJob = findSyncedJob( job );
		if ( syncedJob !== undefined ) {
			job.hasCompletedTranslation = syncedJob.hasCompletedTranslation;
			job.needsUpdate = syncedJob.needsUpdate;
		}

		return job;
	} ).map( job => ( { ...job, status } ) );


	const jobsModifiedByTS = syncedJobs.filter(syncJob => {
		return syncJob.status === status && jobs.find(job => isJobEqual(job, syncJob)) === undefined;
	});

	return translatedJobs.concat(jobsModifiedByTS);
};

export class SyncJobs {
	constructor(jobAPI) {
		this.jobAPI = jobAPI;
	}

	async sync(jobs) {
		const syncedJobs = await this.jobAPI.synchronizeStatusesWithTP(true);
		return {
			ready: getJobsWithStatus(jobs, syncedJobs, JOB_STATUSES.TRANSLATION_READY_TO_DOWNLOAD),
			cancelled: getJobsWithStatus(jobs, syncedJobs, JOB_STATUSES.CANCELLED),
		};
	}


}