import {JOB_STATUSES, hasJobsWithStatus} from "../../jobs/model/jobs";

export default class SyncAndDownload {

	constructor(jobsAPI) {
		this.jobsAPI = jobsAPI;
	}

	async run(elementId, elementType, jobs) {
		if (hasJobsWithStatus(jobs, JOB_STATUSES.TRANSLATION_READY_TO_DOWNLOAD) || hasJobsWithStatus(jobs, JOB_STATUSES.IN_PROGRESS)) {
			return this.jobsAPI.applyTranslationToElement(elementId, elementType).then(translatedJobs => {
				return this.updateJobs(translatedJobs, jobs);
			});
		}

		return jobs;
	}

	updateJobs(relatedJobs, jobs) {
		return jobs.map(job => this.updateJob(relatedJobs, job));
	}

	updateJob(relatedJobs, job) {
		const relatedJob = this.findRelatedJob(job, relatedJobs);

		if (relatedJob) {
			job.status = relatedJob.status;
		}

		return job;
	}

	findRelatedJob(job, relatedJobs) {
		return relatedJobs.find(relatedJob => {
			return relatedJob.id === job.id && relatedJob.type === job.type;
		});
	}
}