import {JOB_STATUSES, hasJobsWithStatus} from "../../jobs/model/jobs";

export default class UIChanges {

	constructor(document, button, icons) {
		this.document = document;
		this.button = button;
		this.icons = icons;

		this.progressClass = "wpml-sync-and-download-translation-progress";
	}

	startProcess() {
		this.button.classList.add(this.progressClass);
	}

	handleResult(jobs) {
		this.button.classList.remove(this.progressClass);

		if (!hasJobsWithStatus(jobs, JOB_STATUSES.IN_PROGRESS) && !hasJobsWithStatus(jobs, JOB_STATUSES.TRANSLATION_READY_TO_DOWNLOAD)) {
			this.button.remove();
		}

		return jobs.map(job => {
			this.updateIcon(job);

			return jobs;
		});
	};

	updateIcon(job) {
		if (job.status !== JOB_STATUSES.CANCELLED && job.status !== JOB_STATUSES.COMPLETED) {
			return;
		}

		let status = job.status;
		if ( status === JOB_STATUSES.CANCELLED && job.hasCompletedTranslation ) {
			if ( job.needsUpdate ) {
				status = JOB_STATUSES.NEEDS_UPDATE;
			} else {
				status = JOB_STATUSES.COMPLETED;
			}
		}

		const selector = `#wpml-job-status-${job.id} > i`;
		const iconTag = this.document.querySelector(selector);

		if (iconTag) {
			if (this.alreadyHasCorrectIcon(iconTag, job)) {
				return;
			}

			const {progress, canceled, completed, needsUpdate} = this.icons;
			switch (status) {
				case JOB_STATUSES.CANCELLED:
					iconTag.classList.replace(progress, canceled);
					break;
				case JOB_STATUSES.NEEDS_UPDATE:
					iconTag.classList.replace(progress, needsUpdate);
					break;
				default:
					iconTag.classList.replace(progress, completed);
			}

			iconTag.classList.add('wpml-blink');
			setTimeout(
				function () {
					iconTag.classList.remove('wpml-blink');
				},
				2000
			);
		}
	};

	alreadyHasCorrectIcon(iconTag, job) {
		return (iconTag.classList.contains(this.icons.completed) && job.status === JOB_STATUSES.COMPLETED) ||
			(iconTag.classList.contains(this.icons.canceled) && job.status === JOB_STATUSES.CANCELLED);
	}
}
