
export default class Sync {

	constructor(button, document, syncAndDownloadFactory, uiChangesFactory) {
		this.button = button;
		this.document = document;
		this.syncAndDownloadFactory = syncAndDownloadFactory;
		this.uiChangesFactory = uiChangesFactory;

		this.state = null;

		button.addEventListener("click", e => this.run(e));
	}

	async run(e) {
		e.preventDefault();

		const {elementId, elementType, jobs, icons} = this.getState();

		const syncAndDownload = this.syncAndDownloadFactory();
		const uiChanges = this.uiChangesFactory(this.document, this.button, icons);

		uiChanges.startProcess();

		return syncAndDownload.run(elementId, elementType, jobs).then(jobs => {
			this.state.jobs = jobs;

			return uiChanges.handleResult(jobs);
		});
	}

	getState() {
		if (!this.state) {
			this.state = {
				elementId: parseInt(this.button.dataset.elementId),
				elementType: this.button.dataset.elementType,
				jobs: JSON.parse(this.button.dataset.jobs),
				icons: JSON.parse(this.button.dataset.icons),
			}
		}

		return this.state;
	}
}

