import React from 'react';
import Modal from "antd/lib/modal";
import Row from "antd/lib/row";
import Col from "antd/lib/col";
import 'antd/lib/modal/style/index.css';
import 'antd/lib/grid/style/index.css';
import 'antd/lib/checkbox/style/index.css';
import {__} from "wpml-common-js-source/src/i18n";
import ModalCloseIcon from "../../../../../../../src/icons/ModalCloseIcon.svg";
import Button from "../../../../../../../src/js/shared/components/button";
import {useStoreActions, useStoreState} from "easy-peasy";
import {identity} from "ramda";

export default () => {
	const {visible, number} = useStoreState(identity);
	const {setVisible} = useStoreActions(identity);

	const closeDialog = () => setVisible(false);

	const submitForm = (deleteDrafts) => {
		document.querySelector('input[name="delete-drafts"]').value = deleteDrafts ? '1' : '0';
		setVisible(false);
		document.querySelector('form[name="translation-jobs-action"]').submit();
	}

	const footer = number
		? <>
			<Row gutter={[0, 32]}>
				<Col span={12} align="left">
					<Button
						type="secondary"
						onClick={() => submitForm(true)}
					>
						{__('Delete Translations', 'wpml-translation-management')}
					</Button>
				</Col>
				<Col span={12} align="right">
					<Button
						type="primary"
						onClick={() => submitForm(false)}
					>
						{__('Keep Translations as Draft', 'wpml-translation-management')}
					</Button>
				</Col>
			</Row>
			<Row gutter={[0, 32]}>
				<Col>
					<a href='#'
					   onClick={closeDialog}
					>
						{__('Never mind. I want to review these translations.', 'wpml-translation-management')}
					</a>
				</Col>
			</Row>
		</>
		: <Row>
			<Col span={12} align="left">
				<Button
					type="secondary"
					onClick={closeDialog}
				>
					{__('Cancel', 'wpml-translation-management')}
				</Button>
			</Col>
		</Row>

	const pleaseSelect = <p>
		{__("You haven't selected any jobs that need review.", 'wpml-translation-management')}
		<br/>
		<br/>
		{__("Please select the pending review jobs to abort.", 'wpml-translation-management')}
	</p>;

	const question = <p>
		{__("This will remove the selected jobs from the Translations Queue without publishing them. What would you like to do with the translations?", 'wpml-translation-management')}
	</p>

	return <Modal
		title={__("Cancel Translation Review", 'wpml-translation-management')}
		visible={visible}
		onCancel={closeDialog}
		maskClosable={false}
		closeIcon={<ModalCloseIcon/>}
		destroyOnClose={true}
		footer={footer}
		className={"wpml-wizard__modal"}
	>
		{number ? question : pleaseSelect}
	</Modal>
}