import {StoreProvider} from "easy-peasy";
import ReactDOM from "react-dom";
import AbortReviewsDialog from "./AbortReviewsDialog";
import React from "react";
import getStore from "./store";

export default () => {

	const store = getStore();

	const abortDialog = document.querySelector('.js-wpml-abort-review-dialog');
	if (abortDialog) {
		ReactDOM.render(
			<StoreProvider store={store}>
				<AbortReviewsDialog/>
			</StoreProvider>,
			abortDialog
		);

	}

	const applyButton = document.getElementById('js-wpml-do-action');
	if( applyButton ) {
		applyButton.addEventListener('click', (event) => {
			const select = document.querySelector('select[name="action2"]');
			if (select.value === 'cancel') {
				event.preventDefault();

				const isNeedsReview = input => {
					const row = input.closest('.js-wpml-job-row');
					return row.querySelector('.otgs-ico-needs-review') !== null;
				};

				const jobsSelectedNeedingReview = [...document
					.querySelectorAll('.js-wpml-job-row input:checked')]
					.filter(isNeedsReview);

				store.getActions().setNumber(jobsSelectedNeedingReview.length);
				store.getActions().setVisible(true);
			}
		});
	}

};