/** globals ate_jobs_sync **/
import ReactDOM from "react-dom";
import {createStore, StoreProvider, action} from "easy-peasy";
import {createSharedStore} from "../ate/status-bar/store";
import ActionButtons from "./ActionButtons";
import React from "react";
import {hooks} from "../ate/jobs-sync/app";
import initializeAbortReview from "./AbortReview/init";

export default () => {
	const isTranslationQueue = !!document.getElementById('icl-translation-jobs');
	if (isTranslationQueue) {
		document.querySelectorAll('#icl-translation-jobs .column-actions div').forEach(el => {
			const job = JSON.parse(el.dataset.job);

			ReactDOM.render(
				<StoreProvider store={createSharedStore(ate_jobs_sync, hooks)}>
					<ActionButtons jobData={job}/>
				</StoreProvider>,
				el
			);
		});

		initializeAbortReview();
	}
};
