/*globals reviewTranslation*/

import React from 'react';
import ReactDOM from 'react-dom';
import {StoreProvider} from "easy-peasy";
import ActionButtons from "./ActionButtons";
import createStore from './store';

document.addEventListener('DOMContentLoaded', () => {
    const translationReviewBox = document.getElementById('wpml_translation_review')
    if (translationReviewBox) {

        reviewTranslation = {
            ...reviewTranslation,
            isPublished: reviewTranslation.isPublished == '1',
            needsReview: reviewTranslation.needsReview == '1',
            inProgressInAte: reviewTranslation.inProgressInAte == '1',
            needsUpdate: reviewTranslation.needsUpdate == '1',
            previousAccepted: reviewTranslation.previousAccepted == '1',
            previousPublished: reviewTranslation.previousPublished == '1'
        };

        ReactDOM.render(
            <StoreProvider store={createStore(reviewTranslation)}>
                <ActionButtons />
            </StoreProvider>,
            translationReviewBox
        )
    }
});
