import {useEffect} from "react";
import {cond, equals, prop} from "ramda";
import {useStoreActions, useStoreState} from "easy-peasy";

export default () => {
    const {isSyncing, hasError, needsUpdate} = useStoreState(prop('ateSync'));
    const {setHasError, sync} = useStoreActions(prop('ateSync'));

    const hideError = () => setTimeout(() => setHasError(false), 5000);

    const reloadPage = () => {
        const url = new URL(window.location.href);
        url.searchParams.delete('complete_no_changes')
        return window.location.href = url.toString();
    };

    const handleSync = async () => {
        const status = await sync();

        cond([
            [equals('error'), hideError],
            [equals('applied'), reloadPage],
            [equals('underway'), () => setTimeout(handleSync, 5000)],
        ])(status);
    };


    useEffect(() => {
        needsUpdate && handleSync();
    }, []);

    return [isSyncing, hasError];
};