import {useEffect} from "react";
import {useStoreActions, useStoreState} from "easy-peasy";
import {prop} from "ramda";

const getJoin = url => url.includes('?') ? '&' : '?';

const urlAppend = ( url, key, value ) => url + getJoin(url) + key + '=' + value;

export default () => {
    const {inProgress, accepted, nextJobUrl} = useStoreState(prop('accept'));
    const {backUrl} = useStoreState(prop('generalData'));
    const {accept} = useStoreActions(prop('accept'));

    const redirectToNextTranslation = (state) => {
        return window.location.href = nextJobUrl
            ? urlAppend( nextJobUrl, 'previousTranslation', state )
            : urlAppend( backUrl, 'reviewCompleted', 'inWPML' );
    }

    const handleAccept = async () => {
        const success = await accept();
        success && redirectToNextTranslation("published");
    };

    useEffect(() => {
            accepted && redirectToNextTranslation("accepted");
        }, []
    );

    return [accepted, handleAccept, inProgress];
};
