import {createStore, action, computed, thunk} from 'easy-peasy';
import {callEndpoint} from "wpml-common-js-source/src/Ajax";
import {always, both, cond, equals, propEq, propOr} from "ramda";

const createATESyncModel = ({endpoints, jobId, postId, completedInATE, needsUpdate}) => ({
    needsUpdate,
    isSyncing: false,
    hasError: false,

    setSyncing: action((state, isSyncing) => {
        state.isSyncing = isSyncing;
    }),
    setHasError: action((state, hasError) => {
        state.hasError = hasError;
    }),

    sync: thunk(async (actions, payload, {getState}) => {
        actions.setSyncing(true);

        const {data} = await callEndpoint(endpoints.update, {jobId, postId, completedInATE});

        const status = !data.success ? 'error' : propOr('error', 'data', data);

        const finishSyncing = () => actions.setSyncing(false);

        const displayError = () => {
            actions.setHasError(true);
            finishSyncing();
        };

        cond([
            [equals('error'), displayError],
            [equals('applied-without-changes'), finishSyncing],
            [equals('in-progress'), finishSyncing],
        ])(status);

        return status;
    }),
});

const createAcceptTranslationMode = ({needsReview, endpoints, jobId, postId, nextJobUrl}) => ({
    accepted: !needsReview,
    inProgress: false,
    nextJobUrl,


    accept: thunk(async (actions) => {
        actions.setInProgress(true);
        const {data: {success}} = await callEndpoint(endpoints.accept, {postId, jobId});
        actions.setInProgress(false);

        success && actions.setAccepted(true);

        return success;
    }),

    setAccepted: action((state, accepted) => {
        state.accepted = accepted;
    }),
    setInProgress: action((state, isInProgress) => {
        state.inProgress = isInProgress;
    }),
});

const createGeneralDataModel = ({previousTranslation, backUrl, jobEditUrl, isPublished}) => ({
    previousTranslation,
    backUrl,
    jobEditUrl,
    isPublished,

    setPreviousTranslation: action((state, previousTranslation) => {
       state.previousTranslation = previousTranslation;
    }),
});

const createModel = jobData => ({
    ateSync: createATESyncModel(jobData),
    accept: createAcceptTranslationMode(jobData),
    generalData: createGeneralDataModel(jobData),
});

export default jobData => createStore(createModel(jobData));