import {JOB_STATUSES} from "../jobs/model/jobs";

export default class CheckJobs {
	constructor(jobAPI) {
		this.jobAPI = jobAPI;
	}

	async hasFinishedRemoteJobs() {
		const params = {
			scope: 'remote',
			status: JOB_STATUSES.COMPLETED,
			limit: 1,
		};

		try {
			const response = await this.jobAPI.loadJobs(params);

			return response.total > 0;
		} catch (e) {
			return false;
		}
	}
}