import React from 'react';
import ReactDOM from 'react-dom';
import {StoreProvider} from 'easy-peasy';
import dataProvider from './dataProvider';
import Sections from './components/Sections';
import AuthorizeModal from './components/AuthorizeModal';

document.addEventListener('DOMContentLoaded', () => {
	const root = document.querySelector('#wpml-tp-services');
	if (root) {
		const store = dataProvider(root);
		ReactDOM.render(<StoreProvider store={store}><AuthorizeModal/><Sections/></StoreProvider>, root);

		if (!!root.dataset.translateEverything) {
			document.querySelector('.wpml-tm-ts-admin-section .js-bottom-section').style.display = 'none';
		}
	}
});
