import React                      from 'react';
import {__, sprintf}              from 'wpml-common-js-source/src/i18n';
import {useStoreActions}          from 'easy-peasy';
import {prop}                     from 'ramda';
import Row                        from 'antd/lib/row';
import Col                        from 'antd/lib/col';
import Input                      from 'antd/lib/input';
import Form                       from 'antd/lib/form';
import ServiceName                from './ServiceName'
import ServiceLogo                from './ServiceLogo'
import 'antd/lib/grid/style/index.css';
import 'antd/lib/input/style/index.css';
import 'antd/lib/image/style/index.css';
import 'antd/lib/form/style/index.css';
import {createInterpolateElement} from '@wordpress/element'


const Connect = ({service}) => {
    const setApiToken = useStoreActions(prop('setApiToken'));

    const description = createInterpolateElement(
        sprintf(__('Visit <link_to_service /> to request an API Token. This token allows WPML to connect to <service_name /> to send and receive jobs.', 'sitepress'), service.name, service.name),
        {
            link_to_service: <ServiceName key="name-with-link" {...service} />,
            service_name   : <ServiceName key="name-without-link" {...service} textOnly={true}/>,
        },
    )

    console.log({service})

    return <>
        <Row>
            <Col span={8}>
                <ServiceLogo {...service}/>
            </Col>
            <Col span={16}>
                <Row>
                    <Col>
                        {description}
                    </Col>
                </Row>
                <Row>
                    <Col>
                        <Form>
                            <Form.Item
                                label="API Token"
                                name="token"
                            >
                                <Input onChange={e => setApiToken(e.target.value)}/>
                            </Form.Item>
                        </Form>
                    </Col>
                </Row>
            </Col>
        </Row>
    </>
};

export default Connect