import React, {useState}               from 'react';
import {__}                            from 'wpml-common-js-source/src/i18n';
import {useStoreActions}               from 'easy-peasy';
import {identity, partial, pipe, prop} from 'ramda';
import Button                          from "../../../../../../../src/js/shared/components/button";
import Col                             from "antd/lib/col";
import Row                             from "antd/lib/row";
import Space                           from "antd/lib/space";
import ServiceLogo                     from './ServiceLogo'
import 'antd/lib/grid/style/index.css';
import 'antd/lib/image/style/index.css';
import 'antd/lib/space/style/index.css';
import {showError}                     from "./Notification";

export default ({service}) => {
    const {id, name, description, doc_url} = service;
    const deactivateService                = useStoreActions(prop('deactivateService'));
    const [inProgress, setInProgress]      = useState(false);

    const onDeactivate = async () => {
        setInProgress(true);

        const onFailure = pipe(
            err => showError(__('Error: ', 'wpml-translation-management') + err),
            partial(setInProgress, [false]),
        );

        const result = await deactivateService(id);
        result.bimap(onFailure, identity);
    };

    return <div className="wpml-active-translation-service" >
        <Row align="middle">
            <Col span={12} >
                <ServiceLogo {...service}/>
            </Col>
            <Col span={12}>
                <Space direction={"vertical"}>
                    <h3>{name}</h3>
                    <div dangerouslySetInnerHTML={{__html: description}}/>

                    <p>
                        <a target="_blank" rel="noopener" href={doc_url}>
                            {__('Documentation', 'wpml-translation-management')}
                        </a>
                    </p>
                </Space>
            </Col>
        </Row>
        <Row>
            <Col align={'left'}>
                <Button loading={inProgress} onClick={onDeactivate} type={'secondary'}>
                    {__('Deactivate', 'wpml-translation-management')}
                </Button>
            </Col>
        </Row>
    </div>;
};
