import React           from 'react'
import Image           from 'antd/lib/image'
import {prop}          from 'ramda'
import {useStoreState} from 'easy-peasy';

const ServiceLogo = ({name, url, logo_url, imageOnly = false}) => {
    const lspPlaceholder = useStoreState(prop('logoPlaceholder'));

    if (!url || !!imageOnly) {
        return <Image alt={name} fallback={lspPlaceholder} src={logo_url} preview={false}/>
    }

    return <a href={url} target="_blank" rel="noreferrer">
        <Image alt={name} fallback={lspPlaceholder} src={logo_url} preview={false}/>
    </a>
}

export default ServiceLogo