import React from 'react';

const getClasses = (num, value) => {
    let cssClasses = 'otgs-ico-star';
    if (num <= value) {
        cssClasses += ' full-star';
    }

    return cssClasses;
};

const Stars = ({maxValue, value}) => {
    const stars = [];
    for (let i = 1; i <= maxValue; i++) {
        stars.push(<span key={i} className={getClasses(i, value)}/>);
    }

    return (
        <span>{stars}</span>
    );
};

export default Stars;