<?php

/**
 *
 * Demo data
 *
 **/

function oceanica_ocdi_import_files() {
    $import_notice = '<h4>' . esc_html__( 'Proceed with this action on initial theme installation only.', 'oceanica' ) . '</h4>';
    $import_notice .=
        esc_html__( 'If you want to use such features as Testimonials and Tiled galleries that are presented in the theme demo, you should perform the following steps before importing sample data.', 'oceanica' ) . '<br/>' .
        '<ol>' .
        '<li>' . esc_html__( 'Install and activate Jetpack plugin if you have not done that yet.', 'oceanica' ) . '</li>' .
        '<li>' . __( 'Connect Jetpack to WordPress.com (it\'s free). Jetpack is a top popular plugin to improve your website at many levels, but if for some reason you don\'t want to connect it to WordPress.com, you can still use it by activating Jetpack Dev Mode with a help of <a href="https://wordpress.org/plugins/jetpack-dev-mode/">this plugin</a>.', 'oceanica' ) . '</li>' .
        '<li>' . sprintf( __( 'Once Jetpack is activated, go to its <a href="%s">settings</a> and activate the following modules: Carousel, Custom content types, Lazy Images, Tiled Galleries. Skip the modules you are not going to use.', 'oceanica' ), admin_url('/admin.php?page=jetpack_modules')) . '</li>' .
        '<li>' . esc_html__( 'Proceed to importing sample data.', 'oceanica' ) . '</li>' .
        '</ol>' .
        esc_html__( 'Data import is generally not immediate and can take up to 10 minutes.', 'oceanica' );

    $import_notice = wp_kses(
        $import_notice,
        array(
            'a' => array(
                'href' => array(),
            ),
            'ol' => array(),
            'li' => array(),
            'h4' => array(),
            'br' => array(),
        )
    );

    return array(
        array(
            'import_file_name'             => 'Demo Import 1',
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'assets/demo-data/oceanica.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'assets/demo-data/oceanica-widgets.wie',
            'import_preview_image_url'     => '',
            'import_notice'                => $import_notice,
            'preview_url'                  => 'https://themes.getmotopress.com/oceanica/',
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'oceanica_ocdi_import_files' );

function oceanica_ocdi_after_import_setup() {

    // Assign menus to their locations.
    $menu1 = get_term_by( 'slug', 'primary', 'nav_menu' );
    $menu2 = get_term_by( 'slug', 'social', 'nav_menu' );
    $menu3 = get_term_by( 'slug', 'contacts', 'nav_menu' );
    $menu4 = get_term_by( 'slug', 'book-online', 'nav_menu' );
    $menu5 = get_term_by( 'slug', 'additional-resources', 'nav_menu' );


    set_theme_mod( 'nav_menu_locations', array(
            'menu-1' => $menu1->term_id,
            'menu-2' => $menu3->term_id,
            'menu-3' => $menu4->term_id,
            'menu-4' => $menu2->term_id
        )
    );

    // Assign menu to widget
    $nav_menu_widget = get_option('widget_nav_menu');

    if($menu5 && $nav_menu_widget && !empty($nav_menu_widget[2])){
        $nav_menu_widget[2]['nav_menu'] = $menu5->term_id;
        update_option('widget_nav_menu', $nav_menu_widget);
    }

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Welcome to Oceanica Hotel' );
    $blog_page_id  = get_page_by_title( 'News' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );


    // Assign Hotel Booking default pages.
    $search_results_page = get_page_by_title('Search Results');
    $booking_confirmation_page = get_page_by_title('Booking Confirmation');
    $booking_confirmed_page = get_page_by_title('Booking Confirmed');
    $booking_cancelled_page = get_page_by_title('Booking Cancellation Page');

    update_option('mphb_search_results_page', $search_results_page->ID);
    update_option('mphb_checkout_page', $booking_confirmation_page->ID);
    update_option('mphb_booking_confirmation_page',$booking_confirmed_page->ID);
    update_option('mphb_user_cancel_redirect_page', $booking_cancelled_page->ID);


    $update_taxonomies = array(
        'product_cat',
        'product_tag',
        'post_tag',
        'category'
    );
    foreach ($update_taxonomies as $taxonomy ) {
        oceanica_ocdi_update_taxonomy( $taxonomy );
    }

    // skip hotel booking wizard
    update_option( 'mphb_wizard_passed', true);

}
add_action( 'pt-ocdi/after_import', 'oceanica_ocdi_after_import_setup' );

// Disable generation of smaller images (thumbnails) during the content import
//add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );

// Disable the branding notice
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

function oceanica_ocdi_update_taxonomy( $taxonomy ) {
    $get_terms_args = array(
        'taxonomy' => $taxonomy,
        'fields' => 'ids',
        'hide_empty' => false,
    );

    $update_terms = get_terms($get_terms_args);
    if ( $taxonomy && $update_terms ) {
        wp_update_term_count_now($update_terms, $taxonomy);
    }
}

add_filter( 'pt-ocdi/importer_options', 'oceanica_ocdi_importer_options' );
function oceanica_ocdi_importer_options( $options ) {
    $options['aggressive_url_search'] = true;

    return $options;
}
