<?php
/**
 * About widget class
 *
 */
require get_template_directory() . '/inc/widgets/Items/Default.php';

class Oceanica_Plugin_Widget_Recent_News extends Oceanica_Plugin_Widget_Default {

	public function __construct() {
		$this->setClassName( 'oceanica_widget_recent_news' );
		$this->setName( esc_html__( 'Recent News', 'oceanica' ) );
		$this->setDescription( esc_html__( 'Recent News', 'oceanica' ) );
		$this->setIdSuffix( 'oceanica_recent_news' );
		parent::__construct();
	}

	public function widget( $args, $instance ) {
		extract( $args );
		$title       = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		echo $before_widget;
		if ( ! empty( $title ) ) {
			echo $before_title . esc_html( $title ) . $after_title;
		}
		$args = apply_filters( 'oceanica_last_news_args', array(
		'post_type'           => 'post',
		'posts_per_page'      => 3,
		'ignore_sticky_posts' => 1,
		'meta_query'          => array( array( 'key' => '_thumbnail_id' ) )
		)
		);

		$parent = new WP_Query( $args );
		$i      = 0;
		if ( $parent->have_posts() ) :?>
		<div class="last-news last-news-<?php echo $parent->post_count; ?>">
			<div class="last-news-wrapper">
				<div class="last-news-col">
					<?php while ( $parent->have_posts() ) :
					$parent->the_post();
					$i ++;
					if ( $i == 2 ) {
					?>
				</div><!--  .last-news-col -->
				<div class="last-news-col">
					<?php } ?>
					<article id="last-news-post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<?php if ( ! ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ) { ?>
							<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
								<?php the_post_thumbnail( 'post-thumbnail' ); ?>
								<i class="fa fa-link" aria-hidden="true"></i>
							</a>
						<?php }
						the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
						?>
					</article><!-- #post-## -->
					<?php endwhile; ?>
				</div><!--  .last-news-col -->

			</div><!-- .entry-child-pages -->
		</div><!-- .entry-child-pages -->
		<?php endif;
		wp_reset_query();
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);

		return $instance;
	}

	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'text' => '' ) );
		$title    = strip_tags( $instance['title'] );
		?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title:', 'oceanica' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>"
			       name="<?php echo $this->get_field_name( 'title' ); ?>" type="text"
			       value="<?php echo esc_attr( $title ); ?>"/></p>

		<?php
	}

}


add_action('widgets_init', 'register_widget_recent_news');

function register_widget_recent_news(){
    register_widget('Oceanica_Plugin_Widget_Recent_News');
}

