/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {
    var style = $( '#oceanica-color-scheme-css' ),
        api = wp.customize;
    if ( ! style.length ) {
        style = $( 'head' ).append( '<style type="text/css" id="oceanica-color-scheme-css" />' )
            .find( '#oceanica-color-scheme-css' );
    }
	// Site title and description.
    api( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
    api( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	// Header text color.
    api( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title a, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title a, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );
				$( '.site-title a, .site-description' ).css( {
					'color': to
				} );
			}
		} );
	} );
    // Color Scheme CSS.
    api.bind( 'preview-ready', function() {
        api.preview.bind( 'update-color-scheme-css', function( css ) {
			console.log('update-color-scheme-css');
            style.html( css );
        } );
    } );

    api('oceanica_icon', function (value) {
		value.bind(function (to) {

            var old_style, new_style;

			new_style = '<style type="text/css" class="oceanica-separator-icon-css">'+
				'.entry-child-pages:after,'+
				'.content-bottom-widgets:after,'+
				'body.single .site-main .entry-header:after,'+
				'body.page .site-main .entry-header:after,'+
				'.site-main .page-header:after{'+
					'content: "' + to + '";'+
				'}'+
				'</style>';

            old_style = $('.oceanica-separator-icon-css');

            if ( old_style.length ) {
                old_style.replaceWith( new_style ); // style element already exists, so replace it
            } else {
                $( 'head' ).append( new_style ); // style element doesn't exist so add it
            }
        })
    });
} )( jQuery );
